set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 6, panel E

**1. Preparing data
use $path_in\KLEMS_b2008_clean, clear
	*Drop country-level aggregates
	drop if code=="TOT"
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
	drop if D1_LP1_EMP==.
	
	*Defining 5-year periods
	gen 	period=1 if year<=1975
	replace period=2 if year>1975&year<=1980
	replace period=3 if year>1980&year<=1985
	replace period=4 if year>1985&year<=1990
	replace period=5 if year>1990&year<=1995
	replace period=6 if year>1995&year<=2000
	replace period=7 if year>2000&year<=2005

	*Cumulate growth per 5-yr period
	foreach var in D1_lnEMP D1_lnH_EMP D1_lnhwage D1_lnLAB D1_lnVA D1_lnVA_P D1_lnVA_QI D1_lnlaborshare D1_lnVA_TOT D1_lnVA_QI_TOT D1_LP1_EMP {
		gen id_`var'=1 if `var'!=.
	}
	collapse (sum) D1_lnEMP D1_lnH_EMP D1_lnhwage D1_lnLAB D1_lnVA D1_lnVA_P D1_lnVA_QI D1_lnlaborshare D1_lnVA_TOT D1_lnVA_QI_TOT D1_LP1_EMP id* (mean) weight*, by(country code sectorgroup cross period)
	
	*Annualizing differences by dividing by total time difference (and setting to missing if zero observations)
	foreach var in D1_lnEMP D1_lnH_EMP D1_lnhwage D1_lnLAB D1_lnVA D1_lnVA_P D1_lnVA_QI D1_lnlaborshare D1_lnVA_TOT D1_lnVA_QI_TOT D1_LP1_EMP {
		replace `var'=. if id_`var'==0
		replace `var'=`var'/id_`var'
	}		
	
	tsset cross period	

	*Keep only full-length intervals
	foreach var in D1_lnEMP D1_lnH_EMP D1_lnhwage D1_lnLAB D1_lnVA D1_lnVA_P D1_lnVA_QI D1_lnlaborshare D1_LP1_EMP {
		drop if id_`var'!=5 
	}
	drop id*
	
	*Standardize TFP 
	drop if D1_LP1_EMP==.
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	
	egen ic=group(code country)
	
	
**2. Table 6, panel E
	cap program drop storeestimates
	program define storeestimates
				est store T6_$col
				lincomest L.D1_LP1_EMP
				estimates store own_$col
				est restore T6_$col
	end		
		
	local own 		"L.D1_LP1_EMP"
	local controls	"i.country*i.period i.sectorgroup"


	**Column 1: Employment
		global col=1
		qui xi:reg D1_lnEMP  `own' `controls' [w=weight_c], clus(ic) 
			storeestimates
			
	**Column 2: Hours worked
		global col=2
		qui xi:reg D1_lnH_EMP  `own' `controls' [w=weight_h_c], clus(ic)
			storeestimates

	**Column 3: Nominal wage bill
		global col=3
		qui xi:reg D1_lnLAB  `own'   `controls' [w=weight_h_c], clus(ic) 
			storeestimates

	**Column 4: Nominal value added
		global col=4
		qui xi:reg D1_lnVA  `own' `controls' [w=weight_VA_c], clus(ic) 
			storeestimates
			
	**Column 5: Real value added
		global col=5
		qui xi:reg D1_lnVA_QI  `own' `controls' [w=weight_VA_c], clus(ic)
			storeestimates
			
	**Column 6: Laborshare
		global col=6
		qui xi:reg D1_lnlaborshare  `own'   `controls' [w=weight_VA_c], clus(ic) 
			storeestimates
			
			
	*Table
	esttab T6_1 T6_2 T6_3 T6_4 T6_5 T6_6, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel E")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 6, panel E")
		}	
		
cap log close		
